using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using System.Collections.Generic;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace PeopleProfileReport
		{
			
			
			public class PeopleBO : StrataFlix.Business.PeopleBO
			{
				
				
				#region " Private Fields "
				
				private static bool _AreCustomDescriptorsEvaluated = false;
				private static MovieCastBBS _MovieCast = new MovieCastBBS();
				private static PeopleImagesBBS _PeopleImages = new PeopleImagesBBS();
				
				#endregion
				
				#region " Protected Methods "
				
				/// <summary>
				/// Determine if the custom descriptors are going to be evaluated
				/// </summary>
				/// <remarks></remarks>
				protected override bool AreCustomDescriptorsEvaluated
				{
					get
					{
						//-- Establish Locals
						bool r = _AreCustomDescriptorsEvaluated;
						
						//-- Do not eval the desciptors again
						_AreCustomDescriptorsEvaluated = true;
						
						//-- Return results
						return r;
					}
				}
				
				/// <summary>
				/// Add additional binding fields
				/// </summary>
				/// <remarks></remarks>
				protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
				{
					//-- Establish Locals
					List<FieldPropertyDescriptor> r = new List<FieldPropertyDescriptor>();
					
					//-- Include all of the base descriptors
					try
					{
						r.AddRange(base.GetCustomBindablePropertyDescriptors());
					}
					catch (Exception)
					{
					}
					
					//-- Add the custom descriptors
					r.Add(new ReflectionPropertyDescriptor("MovieCast", typeof(PeopleBO)));
					r.Add(new ReflectionPropertyDescriptor("PeopleImages", typeof(PeopleBO)));
					
					//-- Return results
					return r.ToArray();
				}
				
				#endregion
				
				#region " Public Properties "
				
				/// <summary>
				/// Returns all of the movie cast records for the current person
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public MovieCastBBS MovieCast
				{
					get
					{
						//-- Make sure that records exists prior to filter
						if (this.Count > 0)
						{
							//-- Filter out the movie cast records for the current person
							_MovieCast.SourceBO.Filter = "mc_pl_pk = " + this.pl_pk.ToString();
						}
						
						return _MovieCast;
					}
				}
				
				/// <summary>
				/// Returns all of the movie images for the current person
				/// </summary>
				/// <value></value>
				/// <returns></returns>
				/// <remarks></remarks>
				public PeopleImagesBBS PeopleImages
				{
					get
					{
						//-- Make sure that records exists prior to filter
						if (this.Count > 0)
						{
							//-- Filter out the movie cast records for the current person
							_PeopleImages.SourceBO.Filter = "pli_pl_pk = " + this.pl_pk.ToString();
						}
						
						return _PeopleImages;
					}
				}
				
				#endregion
				
			}
			
			
		}
	}
}
